// Fade out.cpp

#include "../../SSoundStream.h"

#pragma export on
extern "C"  char *s_name = "Fade out";
extern "C"  char *s_copyright = "Copyright © 1997-98 Olivier Wittenberg";
extern "C"  char *s_version = "1.0";

extern "C" __declspec(dllexport) void s_process_sound(SSoundStream *, SSoundStream *, bool *);
#pragma export reset

// The function almost runs in its own thread, so the stack is still >> 8Kb.
const int32 bufsize = 8192;

void s_process_sound(SSoundStream *inStream, SSoundStream *outStream, bool *quit_asap)
{
	// The stack is large enough.
	int16 buffer[bufsize/2];

	// Try to avoid unnecessary calls to the streams.
	const off_t framecount   = inStream->CountFrames();
	const int32 framesize    = inStream->FrameSize(),
	            channelcount = inStream->CountChannels(),
	            framesperbuf = bufsize / framesize;
	off_t position = 0;
	int32 readframes;

	while (!*quit_asap && (readframes = inStream->ReadFrames((uint8 *)buffer, framesperbuf)) > 0)
	{
		for (int32 i = 0; i < readframes * channelcount ; i += channelcount)
		{
			const float coef = 1 - (position + i) / (float)framecount;

			buffer[i] *= coef;

			if (channelcount == 2)
				buffer[i + 1] *= coef;
		}

		outStream->WriteFrames((uint8 *)buffer, readframes);
		position += readframes;
	}
}